VERSION 5.00
Begin VB.Form capdly_salesDet 
   Caption         =   "#Sales detail"
   ClientHeight    =   7800
   ClientLeft      =   60
   ClientTop       =   360
   ClientWidth     =   10095
   LinkTopic       =   "Form1"
   ScaleHeight     =   7800
   ScaleWidth      =   10095
   StartUpPosition =   3  'Windows Default
   Tag             =   "form_DetailSales"
   Begin VB.Frame frm_salesDetail 
      Caption         =   "#Sales report detail ..."
      Height          =   7005
      Left            =   15
      TabIndex        =   0
      Tag             =   "frm_salesDetail"
      Top             =   810
      Width           =   10125
      Begin VB.Frame frm_salesDetailCalc 
         Height          =   1995
         Left            =   255
         TabIndex        =   4
         Tag             =   "frm_salesDetailCalc"
         Top             =   1950
         Visible         =   0   'False
         Width           =   9165
         Begin VB.Label lbl_salesDetailCalculation 
            Alignment       =   2  'Center
            Caption         =   "#caption calculate sales"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   12
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   1215
            Left            =   150
            TabIndex        =   5
            Tag             =   "lbl_salesDetCal"
            Top             =   300
            Width           =   8880
         End
      End
      Begin VB.Frame frm_grouping 
         Caption         =   "#Grouping"
         Height          =   600
         Left            =   165
         TabIndex        =   1
         Tag             =   "frm_grouping"
         Top             =   270
         Width           =   9405
         Begin VB.CheckBox chk_itemNumber 
            Caption         =   "#Item number"
            Height          =   240
            Left            =   4995
            TabIndex        =   8
            Tag             =   "chk_itemNumber"
            Top             =   285
            Width           =   2325
         End
         Begin VB.CheckBox chk_productFamily 
            Caption         =   "#Product family"
            Height          =   240
            Left            =   2520
            TabIndex        =   3
            Tag             =   "chk_productFamily"
            Top             =   285
            Width           =   2325
         End
         Begin VB.CheckBox chk_BM_Code 
            Caption         =   "#Material"
            Height          =   240
            Left            =   135
            TabIndex        =   2
            Tag             =   "chk_BM_Code"
            Top             =   285
            Width           =   2325
         End
      End
      Begin Project1.ArmGrid grd_list 
         Height          =   5580
         Left            =   90
         TabIndex        =   7
         Tag             =   "grd_salesDetail"
         Top             =   930
         Width           =   9495
         _ExtentX        =   16748
         _ExtentY        =   5662
      End
   End
   Begin Project1.ToolbarControl tlb_main 
      Align           =   1  'Align Top
      Height          =   690
      Left            =   0
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   0
      Width           =   10095
      _ExtentX        =   17912
      _ExtentY        =   1217
   End
End
Attribute VB_Name = "capdly_salesDet"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Option Compare Text
'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK API FUNCTION DECLARES
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long
Private Declare Function GetSystemDefaultLCID Lib "kernel32" () As Long

Private Const COLOR_BLUE  As Long = &HFF0000
Private Const COLOR_GREY2 As Long = &HAAAAAA

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK VARIABLES
'**********************************************************************************************************************************
'**********************************************************************************************************************************
Private Enum ECapReportingTreeview
    creMarket = 1
    creArea = 2
    creMarketRep
End Enum

Public Event ReplacePlaceholders(ByRef as_str As String)


#If ENV = LIVE Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

Private ms_Language_Code                As String       'current user interface language
Private ml_U_code                       As Long         'U_Code (GEN_Systems_Users) of logged user
Private mb_InternalInit                 As Boolean      'framework is doing some own control manipulation, all events should handle

Private ms_TVFilterDesc As String
Private ms_ReportDesc As String

Private ml_Year As Long
Private ml_cboTrw As Long
Private ms_MSA As String
Private ms_Type As String
Private ms_CG_Code As String
Private ms_UOM_Code As String
Private ms_METAL As String

Private ml_level_selected As Long

Private mb_fillGridOnStartup As Boolean

Private mc_ScreenLabels As Long

Private mb_Initialized                  As Boolean      'framework is initialised or not

Private Const SEP = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SCREEN_NAME       As String = "Capture_Rrpt_SalesDetail"
Private ms_DecimalSeparator             As String       'locale decimal separator
Private ms_ThousandSeparator            As String       'locale thousand separator

Private Const SW_SHOWNORMAL = 1
Private Const LOCALE_USER_DEFAULT = &H400
Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12          ' load function failed ... bad sql
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum


'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK CUSTOM METHODS
' Change content of methods as you need, but do not add any new method or property here !
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Function Load_A_COM_Custom() As Boolean
On Error GoTo ErrHandler
    
    Load_A_COM_Custom = True
    Exit Function
ErrHandler:
    Call ErrorHandler("Load_A_COM_Custom")
End Function

Private Sub UnLoad_A_COM_Custom()
On Error GoTo ErrHandler

    Exit Sub
ErrHandler:
    Call ErrorHandler("UnLoad_A_COM_Custom")
End Sub

Public Function Run(ByVal al_cboTrw As Long, ByVal as_MSA As String, ByVal as_Type As String, ByVal al_Year As Long, ByVal as_CG_Code As String, ByVal as_UOM_Code As String, ByVal as_METAL As String) As Boolean
On Error GoTo ErrorHandler
    Run = False
    
    ml_Year = al_Year
    ml_cboTrw = al_cboTrw
    ms_MSA = as_MSA
    ms_Type = as_Type                   ' GSV/VOL
    ms_CG_Code = as_CG_Code             ' C001, c002, null
    ms_UOM_Code = as_UOM_Code           ' M2, LM, Piece ...
    ms_METAL = as_METAL                 ' 'X', '', NULL
    
    ' init screen controls
    Call tlb_main.DisplayFace("0")
    ' according level/type of treeview display possible groupping
    
    ' hide the grid
    grd_list.Visible = False
    
    ' show detail frame
    frm_salesDetail.Caption = ""
    
    Call DefineSalesGrid(grd_list)
    
    ' display form
    Me.show 1
    
    Run = True
    Exit Function
ErrorHandler:
    Call ErrorMessage("Run")
End Function

Private Sub Init_Custom()
On Error GoTo ErrHandler
Const CL_REQUEST_TB As String = "A_ToolbarDef_sel 1, 2442, 2830, $id$"
Const TLB_DETAIL_ID As Long = 2857

    'Initialization of the component of the form
    ' toolbar init
    ' main toolbar
    Dim ll_Cursor  As Long
    ll_Cursor = OpenSQLSafe(mo_Db, Replace(CL_REQUEST_TB, "$id$", "NULL"))
    If mo_Db.Find(ll_Cursor, "id", TLB_DETAIL_ID) >= 0 Then
        Call tlb_main.SetToolbarInfoStringParameters(mo_Db.GetFields(ll_Cursor, "info"), Left(mo_Db.GetFields(ll_Cursor, "info"), 3))
    Else
        Call Err.Raise(ArmErr.InvalidArgument, "mo_Db.Find", "Toolbar id(" & TLB_DETAIL_ID & ") not found in DB")
    End If
    
    Call mo_Db.Close(ll_Cursor)
    
    grd_list.ExportTitles = True
    grd_list.AllowExcelExport = True
    grd_list.FetchAll = True
    grd_list.AllowSort = False

    Exit Sub
ErrHandler:
    If ll_Cursor > 0 Then Call mo_Db.Close(ll_Cursor)
    Call ErrorHandler("Init_Custom")
End Sub

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK PROPERTIES
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Property Let TVFilterDesc(ByVal as_TVDesc As String)
    ms_TVFilterDesc = as_TVDesc
End Property

Public Property Let ReportDesc(ByVal as_ReportDesc As String)
    ms_ReportDesc = as_ReportDesc
End Property

Public Property Let Level_selected(ByVal al_level_selected As Long)
    ml_level_selected = al_level_selected
End Property

Public Property Let ScreenLabels(ByVal lc_ScreenLabels As Long)
    mc_ScreenLabels = lc_ScreenLabels
End Property

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property


Property Let U_Code(al_Code As Long)
ml_U_code = al_Code
End Property

Property Let Language_Code(AString As String)
ms_Language_Code = AString
End Property

Public Property Set ArmDb(ByRef local_connection As Object)
    If Not (local_connection Is Nothing) Then
        Set mo_Db = local_connection
    End If
End Property


'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK METHODS
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Function Load_A_Com() As Boolean

Dim ll_Index As Long
Dim lo_Control As Object

On Error GoTo ErrHandler
    
    Load_A_Com = False
    
    If mb_Initialized Then
        Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    End If
    
    mb_InternalInit = False
    ms_DecimalSeparator = Format(0, ".")
    mb_fillGridOnStartup = False
    
    ReDim mt_MainConfig(-1 To -1)
    ReDim mt_DetailConfig(-1 To -1)
    ReDim mt_SubdetailConfig(-1 To -1)
    
    Dim sBuffer As String
    Dim nBufferLen As Long
    nBufferLen = 255
    sBuffer = String$(nBufferLen, vbNullChar)
    nBufferLen = GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, sBuffer, nBufferLen)
    If nBufferLen > 0 Then
        ms_ThousandSeparator = Left$(sBuffer, nBufferLen - 1)
    End If
    
    For Each lo_Control In Me.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "ARMPICKER"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "TOOLBARCONTROL"
            lo_Control.Language = ms_Language_Code
            lo_Control.Load_A_Com
        Case "TOOLBR"
            Set lo_Control.ArmDb = mo_Db
            lo_Control.Language = ms_Language_Code
            Call lo_Control.Load_A_Com
        Case "ARMGRID"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "ARMTREEVIEW"
            Set lo_Control.ArmDb = mo_Db
            lo_Control.Language = ms_Language_Code
            Call lo_Control.Load_A_Com
        Case "ARMCHECKVIEW"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "A_CALOCX"
            lo_Control.Language = ms_Language_Code
            Call lo_Control.reinit_cal
        End Select
    Next
    Call Form_Resize
    mb_Initialized = Load_A_COM_Custom
    Load_A_Com = mb_Initialized
    Exit Function
ErrHandler:
    Load_A_Com = False
    Call ErrorMessage("Load_A_COM")
End Function

Public Function Unload_A_Com() As Boolean
    
On Error GoTo ErrHandler
    
    Dim lo_Control As Object
    Dim ll_Index As Long
    
    Call UnLoad_A_COM_Custom
    
    For Each lo_Control In Me.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX", "TOOLBARCONTROL", "ARMGRID", "ARMTREEVIEW", "ARMCHECKVIEW", "ARMPICKER"
            Call lo_Control.Unload_A_Com
        End Select
    Next
    
    Set mo_Db = Nothing
    mb_Initialized = False
    Unload_A_Com = True
    Exit Function
ErrHandler:
    Unload_A_Com = False
    Call ErrorMessage("Unload_A_Com")
End Function

Public Sub Resize()
On Error GoTo ErrHandler

    Exit Sub
ErrHandler:
    Call ErrorMessage("Resize")
End Sub

Public Function Init_control() As Boolean
Dim ll_Index As Long

On Error GoTo ErrHandler

    Call Init_Custom
    
    Call ChangeCharset(Me.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))
    Call LoadLabels(mo_Db, Me, mc_ScreenLabels)
    
    Init_control = True
    Exit Function
ErrHandler:
    Init_control = False
    Call ErrorMessage("Init_control")
End Function

Private Function HasContainer(ByVal lo_Control As Control, ByRef lo_Container As Object) As Boolean
    Dim ll_Index As Long
    Dim lo_Object As Object

    On Error GoTo CleanUp   'not all controls support Container property
    HasContainer = False
    While Not (lo_Control Is Nothing)
        If lo_Control.Container Is lo_Container Then
            HasContainer = True
            Exit Function
        End If
        Set lo_Control = lo_Control.Container
    Wend

CleanUp:

End Function

Private Sub ResetFrameControls(ByRef ao_Frame As Frame)
On Error GoTo ErrHandler

Dim lo_Control As Control

    mb_InternalInit = True
    For Each lo_Control In Me.Controls
    
        If HasContainer(lo_Control, ao_Frame) Then
            Select Case UCase(TypeName(lo_Control))
                Case "ARMCOMBOBOX"
                    Call lo_Control.Clear
                    lo_Control.Tag = ""
                    lo_Control.Request = ""
                    lo_Control.Visible = False
                Case "ARMPICKER"
                    Call lo_Control.Clear
                    lo_Control.Tag = ""
                    lo_Control.Visible = False
                Case "CHECKBOX"
                    lo_Control.value = Unchecked
                    lo_Control.Tag = ""
                    lo_Control.Caption = ""
                    lo_Control.Visible = False
                Case "TEXTBOX"
                    lo_Control.Tag = ""
                    lo_Control.Text = ""
                    lo_Control.Visible = False
                Case "A_CALOCX"
                    Call lo_Control.reinit_cal
                    lo_Control.Tag = ""
                    lo_Control.Visible = False
                Case "LABEL"
                    lo_Control.Tag = ""
                    lo_Control.Caption = ""
                    lo_Control.FontBold = False
                    lo_Control.Visible = False
            End Select
        End If
    Next
    mb_InternalInit = False
    Exit Sub
ErrHandler:
    mb_InternalInit = False
    Call ErrorHandler("ResetFrameControls")
End Sub

' ************************************************************************************
' FRAMEWORK DB-ACCESS FUNCTIONS
' please do not change this code
' ************************************************************************************

' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If ENV = LIVE Then
Private Function OpenSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data

    Exit Function

ErrHandler:

    Call ErrorHandler("OpenSQLSafe")

End Function


' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If ENV = LIVE Then
Private Sub ExecuteSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmCusErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            End If
        End If
    End If

    Exit Sub

ErrHandler:
    Call ErrorHandler("ExecuteSQLSafe")
End Sub

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo ErrHandler
    
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(mo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetDbError()")
End Function
' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_ErrDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_ErrDescription = Err.Description
    
    Call LogMessage(SCREEN_NAME & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_ErrDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_ErrDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' logs message to database
Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "E", Optional ab_ExitOnException As Boolean = False)
    Dim ll_errNumber As Long
    Dim ls_ErrDescription As String, ls_ErrSource As String
    
    ll_errNumber = Err.Number
    ls_ErrDescription = Err.Description
    ls_ErrSource = Err.Source

On Error GoTo ErrHandler

Const LOG_REQUEST As String = "EXEC A_log_ins $UCODE$,$LOGTYPE$,$MSG$,$APP$"
    Dim ls_req As String
    Dim ll_Cursor As Long
    Dim ls_Source As String, ls_Msg As String
    
    ls_Source = SCREEN_NAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    ls_Msg = as_logMsg & SEP1 & ll_errNumber & " : " & ls_ErrDescription & " - " & ls_ErrSource
    
    ls_req = ReplacePlaceHolder(LOG_REQUEST, "$UCODE$", CStr(ml_U_code))
    ls_req = ReplacePlaceHolder(ls_req, "$LOGTYPE$", SQLStr(as_logType))
    ls_req = ReplacePlaceHolder(ls_req, "$MSG$", Left(Trim(SQLStr(ls_Msg)), 4000))
    ls_req = ReplacePlaceHolder(ls_req, "$APP$", Left(Trim(SQLStr(ls_Source)), 50))
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Err.Number = ll_errNumber
    Err.Description = ls_ErrDescription
    Err.Source = ls_ErrSource
    Exit Sub
    
ErrHandler:
    If ab_ExitOnException Then
        Call MsgBox("A fatal error occured. Unable to log error into database, the application will be close. Please report the following message to your IT support: " & vbCrLf & _
            "Number:" & Err.Number & vbCrLf & "Description:" & Err.Description, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
        End
    End If
    Err.Number = ll_errNumber
    Err.Description = ls_ErrDescription
    Err.Source = ls_ErrSource
End Sub

Private Function SQLStr(ByVal as_Data As String) As String
On Error GoTo ErrHandler

    SQLStr = "'" & Replace(as_Data, "'", "''") & "'"
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlStr")
End Function

Private Function ReplacePlaceHolder(ByVal as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As String
On Error GoTo ErrHandler
    
    as_Request = Replace(as_Request, as_PlaceHolder, as_DefaultValue, , , vbTextCompare)
    
    ReplacePlaceHolder = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplacePlaceholder")
End Function

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        Me.Enabled = False
        LockWindowUpdate Me.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        Me.Enabled = True
        Me.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    Exit Sub
ErrHandler:
    Call ErrorHandler("LockScreen")
End Sub


' ************************************************************************************
' *************************** INTERNATIONAL FUNCTIONS ********************************
' ************************************************************************************

Private Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal as_Language As String) As Long
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT Code_Page FROM Language WHERE Language_Code = '$Language_Code$'"
    Dim ls_req As String
    Dim ll_Cursor As Long
    Dim ll_codePage As Long
    
    ls_req = ReplacePlaceHolder(C_REQ, "$Language_Code$", as_Language)

    ll_Cursor = OpenSQLSafe(ao_Armdb, ls_req)
    Debug.Assert (ll_Cursor <> 0)
    
    ll_codePage = CLng(ao_Armdb.GetFields(ll_Cursor, "Code_Page"))
    Call ao_Armdb.Close(ll_Cursor)
    GetCodePageFromLanguage = ll_codePage
    Exit Function
    
ErrHandler:
    If ll_Cursor <> 0 Then Call ao_Armdb.Close(ll_Cursor)
    Call ErrorHandler("GetCodePageFromLanguage()")
End Function

'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetCharSetFromCodePage()")
End Function

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)

On Error GoTo ErrHandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0", "ARMPICKER"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("ChangeCharset")
End Sub

' Load the labels of a containers
Private Sub LoadLabels(ByRef ao_Armdb As ArmDb, ByRef ao_Container As Object, ByVal lc_Labels As Long)
Dim lo_Control As Control   ' A control of the container
Dim li_Idx As Integer, li_Count As Integer
Dim li_Label As Integer      ' A label idx
Dim lsa_ControlTag() As String
    
    On Error GoTo Trace_Err

    On Error GoTo WithoutTag
    If ao_Container.Tag <> "" Then
        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", Me.Tag, , 1)
        If li_Label >= 0 Then
            Me.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
        End If
    End If
WithoutTag:
    
    On Error GoTo Trace_Err
    
    ' Iterate the container for loading the label of each element which has defined a tag
    For Each lo_Control In Me.Controls
        
        If HasContainer(lo_Control, ao_Container) Or _
          ((ao_Container Is Me) And (UCase(TypeName(lo_Control)) = "MENU")) Then
            Select Case UCase(TypeName(lo_Control))
                Case UCase("TabStrip") ' Component is a tabstrip, we load the caption of each tab defined
                    Dim lo_Tbs
                    Set lo_Tbs = lo_Control ' Cast for use of intellisense
                    li_Count = lo_Tbs.Tabs.Count
                    For li_Idx = 1 To li_Count
                        If lo_Tbs.Tabs(li_Idx).Tag <> "" Then
                            li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Tbs.Tabs(li_Idx).Tag, , 1)
                            If li_Label >= 0 Then
                                lo_Tbs.Tabs(li_Idx).Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                            End If
                        End If
                    Next
                    Set lo_Tbs = Nothing
                
                Case UCase("ListView") ' Component is a listview, we load the caption of each columns
                    Dim lo_ListView As ListView
                    Set lo_ListView = lo_Control
                    li_Count = lo_ListView.ColumnHeaders.Count
                    For li_Idx = 1 To li_Count
                        If lo_ListView.ColumnHeaders(li_Idx).Tag <> "" Then
                            li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_ListView.ColumnHeaders(li_Idx).Tag, , 1)
                            If li_Label >= 0 Then
                                lo_ListView.ColumnHeaders(li_Idx).Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                            End If
                        End If
                    Next
                    Set lo_ListView = Nothing
            
                Case UCase("TextBox")  ' Component is a textbox
                    Dim lo_TextBox As TextBox
                    Set lo_TextBox = lo_Control
                    If lo_TextBox.Tag <> "" Then
                        lsa_ControlTag = Split(lo_Control.Tag, SEP)
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lsa_ControlTag(0), , 1)
                        If li_Label >= 0 Then
                            lo_TextBox.Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                    Set lo_TextBox = Nothing
                
                Case UCase("Label"), UCase("Frame"), UCase("CommandButton"), UCase("CheckBox"), UCase("OptionButton")
                    If lo_Control.Tag <> "" Then
                        lsa_ControlTag = Split(lo_Control.Tag, SEP)
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lsa_ControlTag(0), , 1)
                        If li_Label >= 0 Then
                            lo_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                Case UCase("ArmGrid")
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag, , 1)
                    If li_Label >= 0 Then
                      Call lo_Control.LoadConstants(ptStatic, ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT"), ctColumns)
                    End If
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag & "_Title", , 1)
                    If li_Label >= 0 Then
                      lo_Control.Title = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                    End If
                Case UCase("Menu")
                    If lo_Control.Tag <> "" Then
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag, , 1)
                        If li_Label >= 0 Then
                            lo_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
            End Select
        End If
    Next
    
Trace_End:
    Exit Sub
    
Trace_Err:
      
End Sub

Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String
On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = ReplacePlaceHolder(DB_REQ, "$id$", aID)
    lRequest = ReplacePlaceHolder(lRequest, "$lang$", aLang)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call MsgBox("Connection failure accessing message information.", vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    MsgText = aDefault
End Function


Private Sub Form_Resize()
    frm_salesDetail.Top = tlb_main.Top + tlb_main.Height
    frm_salesDetail.Width = Me.Width - 120
    If Me.Height - (tlb_main.Top + tlb_main.Height) > 600 Then
        frm_salesDetail.Height = Me.Height - (tlb_main.Top + tlb_main.Height) - 430
    Else
        frm_salesDetail.Height = 200
    End If
    
    frm_grouping.Left = 60
    frm_grouping.Top = 260
    If frm_salesDetail.Width > 520 Then
        frm_grouping.Width = frm_salesDetail.Width - 120
    Else
        frm_grouping.Width = 520
    End If
        
    
    grd_list.Left = frm_grouping.Left
    grd_list.Top = frm_grouping.Top + frm_grouping.Height
    grd_list.Width = frm_grouping.Width
    If frm_salesDetail.Height - (frm_grouping.Top + frm_grouping.Height) > 100 Then
        grd_list.Height = frm_salesDetail.Height - (frm_grouping.Top + frm_grouping.Height) - 60
    Else
        grd_list.Height = 100
    End If
    
    frm_salesDetailCalc.Left = frm_grouping.Left
    frm_salesDetailCalc.Width = frm_grouping.Width
    lbl_salesDetailCalculation.Left = 60
    lbl_salesDetailCalculation.Width = frm_salesDetailCalc.Width - 120
'    tlb_main.Redraw
    If mb_fillGridOnStartup Then
        mb_fillGridOnStartup = False
        Call Process_SalesDetail(ml_Year, ml_cboTrw)
    End If
End Sub

Private Sub Process_SalesDetail(ByVal al_Year As Long, ByVal al_TVFilterCode As Long)
On Error GoTo ErrorHandler
    Dim ls_req As String

    grd_list.Visible = False
    
    ReDim ms_MsgInfo(2, 1)
    ms_MsgInfo(0, 0) = "$TV1$"
    ms_MsgInfo(0, 1) = ms_TVFilterDesc
    ms_MsgInfo(1, 0) = "$MONTH$"
    ms_MsgInfo(1, 1) = al_Year
    ms_MsgInfo(2, 0) = "$DESC$"
    ms_MsgInfo(2, 1) = ms_ReportDesc
    
    
    frm_salesDetail.Visible = True
    frm_salesDetail.Caption = GetLabel(frm_salesDetail.Tag, "#$DESC$: $TV1$ $MONTH$", ms_MsgInfo)

    Call grd_list.ClearGrid
    frm_salesDetailCalc.Visible = True
    
    lbl_salesDetailCalculation.Caption = GetLabel(lbl_salesDetailCalculation.Tag, "#Calculating Sales detail report ....")
    Call frm_salesDetail.Refresh
    DoEvents
    
    ls_req = GetSalesDetailRequest(al_TVFilterCode, ms_Type, ms_MSA, IIf(chk_BM_Code.value = vbChecked, "BM", ""), IIf(chk_productFamily.value = vbChecked, "PF", ""), IIf(chk_itemNumber.value = vbChecked, "BI", ""))
    
    If ls_req <> "" Then
        RaiseEvent ReplacePlaceholders(ls_req)
        ls_req = Replace(ls_req, "$PYEAR$", al_Year)
        ls_req = Replace(ls_req, "$PCG_CODE$", ms_CG_Code, , , vbTextCompare)
        ls_req = Replace(ls_req, IIf(ms_UOM_Code = "NULL", "'$UOM_CODE$'", "$UOM_CODE$"), ms_UOM_Code, , , vbTextCompare)
        ls_req = Replace(ls_req, "$METAL$", ms_METAL, , , vbTextCompare)
        
        grd_list.Requests = ls_req
        If Not grd_list.Execute Then
            MsgBox "An error occured during this query, please take a screenshot and contact IT support"
        Else
            ' CALCULATE SUM for Top 10 and Other separatelly
            Dim lo_sumLine As New Dictionary
            
            Dim ll_i As Long
            For ll_i = 0 To grd_list.Cols - 1
                Call lo_sumLine.Add(grd_list.Columns(ll_i).Name, Empty)
            Next
            
            
            lo_sumLine("GRP_DESC") = GetLabel("s_total", "#TOTAL")
            
            For ll_i = 0 To grd_list.Rows - 1
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "JAN")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "FEB")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "MARCH")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "APRIL")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "MAY")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "JUNE")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "JULY")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "AUG")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "SEP")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "OCT")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "NOV")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "DEC")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "TOTAL")
            Next ll_i

            Call grd_list.AddLine(lo_sumLine.Items())
            grd_list.LineColor(grd_list.Rows - 1) = COLOR_GREY2
            grd_list.TextColor(grd_list.Rows - 1) = COLOR_BLUE
        End If
        
        grd_list.Visible = True
        lbl_salesDetailCalculation.Caption = ""
        frm_salesDetailCalc.Visible = False
    End If

    grd_list.Visible = True
    
    Exit Sub
ErrorHandler:
    Call ErrorHandler(Me.Name & ".Process_SalesDetail")
End Sub


Private Sub GrdColumToSUMLine(ByRef ao_grd As ArmGrid, ByRef ao_sumLine As Dictionary, ByVal al_Row As Long, ByVal as_colName As String)
On Error GoTo ErrorHandler
    If ao_sumLine.Exists(as_colName) Then
        ao_sumLine(as_colName) = ao_sumLine(as_colName) + ao_grd.Data(al_Row, as_colName)
    End If
    Exit Sub
ErrorHandler:
    Call ErrorHandler(Me.Name & ".GrdColumToSUMLine")
End Sub

Private Function GetLabel(ByVal as_Tag As String, ByVal as_DefaultValue As String, Optional ByVal aInfo As Variant) As String
    
    If mo_Db.Find(mc_ScreenLabels, "FIELD_NAME", as_Tag, , 1) >= 0 Then
        as_DefaultValue = mo_Db.GetFields(mc_ScreenLabels, "LOCAL_TEXT")
    End If
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            as_DefaultValue = Replace(as_DefaultValue, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    GetLabel = as_DefaultValue

End Function




Private Function GetSalesDetailRequest(ByVal al_trwCode As Long, ByVal as_Type As String, ByVal as_MSA As String, ByVal as_Grp1 As String, ByVal as_Grp2 As String, ByVal as_Grp3 As String) As String
On Error GoTo ErrorHandler

    Dim ls_retVal As String
    Select Case al_trwCode
        Case 1, 3, 5 ' Market
            ls_retVal = "EXEC Sales_Det$TYPE$_Market$GRP1$$GRP2$$GRP3$$MSA$ $PYEAR$, $mkt_code$, $CT_Code$, $z_creator$, $ccu_capkey$, $PCG_CODE$, '$UOM_CODE$', $AS_FLAG$, $METAL$"
        Case 2, 4  ' Area
            ls_retVal = "EXEC Sales_Det$TYPE$_RepGrp$GRP1$$GRP2$$GRP3$$MSA$ $PYEAR$, $RAR_Code$, $z_creator$, $ccu_capkey$, $PCG_CODE$, '$UOM_CODE$', $AS_FLAG$, $METAL$"
        Case 3  ' Market
            ls_retVal = "EXEC Sales_Det$TYPE$_Market$GRP1$$GRP2$$GRP3$$MSA$ $PYEAR$, $mkt_code$, $CT_Code$, $z_creator$, $ccu_capkey$, $PCG_CODE$, '$UOM_CODE$', $AS_FLAG$, $METAL$"
    End Select
    
    ls_retVal = Replace(ls_retVal, "$TYPE$", as_Type, , , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$MSA$", as_MSA, , , vbTextCompare)
    
    'replace grouping
    ls_retVal = Replace(ls_retVal, "$GRP1$", as_Grp1, , , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$GRP2$", as_Grp2, , , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$GRP3$", as_Grp3, , , vbTextCompare)


    GetSalesDetailRequest = ls_retVal

   Exit Function
    
ErrorHandler:
    Call ErrorHandler(Me.Name & ".GetSalesDetailRequest")
End Function

Private Sub DefineSalesGrid(ByRef ao_grid As ArmGrid)
On Error GoTo ErrorHandler

    ao_grid.Title = "#Sales detail view"
    
    ReDim la_Columns(13) As String
    la_Columns(0) = "GRP_DESC" & CH_LDELIMIT & "2500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "GRP_DESC" & CH_LDELIMIT & GetLabel("frm_grouping", "#Grouping")
    la_Columns(1) = "JAN" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "JAN" & CH_LDELIMIT & GetLabel("s_jan", "#Jan") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    la_Columns(2) = "FEB" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "FEB" & CH_LDELIMIT & GetLabel("s_feb", "#Feb") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    la_Columns(3) = "MARCH" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "MARCH" & CH_LDELIMIT & GetLabel("s_march", "#March") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    la_Columns(4) = "APRIL" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "APRIL" & CH_LDELIMIT & GetLabel("s_april", "#April") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    la_Columns(5) = "MAY" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "MAY" & CH_LDELIMIT & GetLabel("s_may", "#May") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    la_Columns(6) = "JUNE" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "JUNE" & CH_LDELIMIT & GetLabel("s_jun", "#Jun") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    la_Columns(7) = "JULY" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "JULY" & CH_LDELIMIT & GetLabel("s_july", "#July") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    la_Columns(8) = "AUG" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "AUG" & CH_LDELIMIT & GetLabel("s_august", "#August") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    la_Columns(9) = "SEP" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SEP" & CH_LDELIMIT & GetLabel("s_sept", "#Sept") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    la_Columns(10) = "OCT" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "OCT" & CH_LDELIMIT & GetLabel("s_oct", "#Oct") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    la_Columns(11) = "NOV" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "NOV" & CH_LDELIMIT & GetLabel("s_nov", "#Nov") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    la_Columns(12) = "DEC" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "DEC" & CH_LDELIMIT & GetLabel("s_dec", "#Dec") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    la_Columns(13) = "TOTAL" & CH_LDELIMIT & "1200" & CH_LDELIMIT & "0" & CH_LDELIMIT & "TOTAL" & CH_LDELIMIT & GetLabel("s_total", "#TOTAL") & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
    
    
    Call ao_grid.SetColumns(la_Columns)
    
    ' translate
'    If mo_Db.Find(mc_ScreenLabels, "FIELD_NAME", "grd_main_cols", , 1) >= 0 Then
'      Call ao_grid.LoadConstants(ptStatic, mo_Db.GetFields(mc_ScreenLabels, "LOCAL_TEXT"), ctColumns)
'    End If
    If mo_Db.Find(mc_ScreenLabels, "FIELD_NAME", "grd_salesDet_Title", , 1) >= 0 Then
      ao_grid.Title = mo_Db.GetFields(mc_ScreenLabels, "LOCAL_TEXT")
    End If
    
    Exit Sub
ErrorHandler:
    Call ErrorHandler(Me.Name & ".DefineSalesGrid")
End Sub


Private Sub tlb_Main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    
    Call LockScreen(True)
    tlb_main.Enabled = False

    Select Case as_Role
        Case "L"
            ' display the detail
            If (chk_BM_Code.value = vbUnchecked) And (chk_productFamily.value = vbUnchecked) And (chk_itemNumber.value = vbUnchecked) Then
                MsgBox MsgText(1513, ms_Language_Code, "#Select grouping please.")
            Else
                Call LockScreen(False)
                Call Process_SalesDetail(ml_Year, ml_cboTrw)
                Call LockScreen(True)
            End If
        Case "T"
            Me.Hide
    End Select
    
    tlb_main.Enabled = True
    
    Call LockScreen(False)
    Exit Sub

ErrHandler:
    tlb_main.Enabled = True
    Call LockScreen(False)
    
    Call LogMessage("tlb_Main_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
End Sub


